#!/bin/sh

set -eu

DEB_EDK2_ROOT="${DEB_EDK2_ROOT:-}"

exit_code=0

list_filenames_in_json() {
    local json
    json="$1"

    jq -r '.. | .filename? | select(. != null)' < "$json"
}

for desc in "${DEB_EDK2_ROOT}"/usr/share/qemu/firmware/*.json; do
    for file in $(list_filenames_in_json "$desc"); do
	file="${DEB_EDK2_ROOT}${file}"
	[ ! -f "${file}" ] || continue
	echo "ERROR: ${desc}: Referenced file does not exist: ${file}" 1>&2
	exit_code=1
    done
done

exit $exit_code
