//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armintegrationspaces

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// BusinessProcessVersionsClient contains the methods for the BusinessProcessVersions group.
// Don't use this type directly, use NewBusinessProcessVersionsClient() instead.
type BusinessProcessVersionsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewBusinessProcessVersionsClient creates a new instance of BusinessProcessVersionsClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewBusinessProcessVersionsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*BusinessProcessVersionsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &BusinessProcessVersionsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Get a BusinessProcessVersion
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - applicationName - The name of the Application
//   - businessProcessName - The name of the business process
//   - businessProcessVersion - The version of the business process
//   - options - BusinessProcessVersionsClientGetOptions contains the optional parameters for the BusinessProcessVersionsClient.Get
//     method.
func (client *BusinessProcessVersionsClient) Get(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, businessProcessName string, businessProcessVersion string, options *BusinessProcessVersionsClientGetOptions) (BusinessProcessVersionsClientGetResponse, error) {
	var err error
	const operationName = "BusinessProcessVersionsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, spaceName, applicationName, businessProcessName, businessProcessVersion, options)
	if err != nil {
		return BusinessProcessVersionsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return BusinessProcessVersionsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return BusinessProcessVersionsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *BusinessProcessVersionsClient) getCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, businessProcessName string, businessProcessVersion string, options *BusinessProcessVersionsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/applications/{applicationName}/businessProcesses/{businessProcessName}/versions/{businessProcessVersion}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	if applicationName == "" {
		return nil, errors.New("parameter applicationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{applicationName}", url.PathEscape(applicationName))
	if businessProcessName == "" {
		return nil, errors.New("parameter businessProcessName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{businessProcessName}", url.PathEscape(businessProcessName))
	if businessProcessVersion == "" {
		return nil, errors.New("parameter businessProcessVersion cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{businessProcessVersion}", url.PathEscape(businessProcessVersion))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *BusinessProcessVersionsClient) getHandleResponse(resp *http.Response) (BusinessProcessVersionsClientGetResponse, error) {
	result := BusinessProcessVersionsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BusinessProcessVersion); err != nil {
		return BusinessProcessVersionsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByBusinessProcessPager - List BusinessProcessVersion resources by BusinessProcess
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - applicationName - The name of the Application
//   - businessProcessName - The name of the business process
//   - options - BusinessProcessVersionsClientListByBusinessProcessOptions contains the optional parameters for the BusinessProcessVersionsClient.NewListByBusinessProcessPager
//     method.
func (client *BusinessProcessVersionsClient) NewListByBusinessProcessPager(resourceGroupName string, spaceName string, applicationName string, businessProcessName string, options *BusinessProcessVersionsClientListByBusinessProcessOptions) *runtime.Pager[BusinessProcessVersionsClientListByBusinessProcessResponse] {
	return runtime.NewPager(runtime.PagingHandler[BusinessProcessVersionsClientListByBusinessProcessResponse]{
		More: func(page BusinessProcessVersionsClientListByBusinessProcessResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *BusinessProcessVersionsClientListByBusinessProcessResponse) (BusinessProcessVersionsClientListByBusinessProcessResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "BusinessProcessVersionsClient.NewListByBusinessProcessPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByBusinessProcessCreateRequest(ctx, resourceGroupName, spaceName, applicationName, businessProcessName, options)
			}, nil)
			if err != nil {
				return BusinessProcessVersionsClientListByBusinessProcessResponse{}, err
			}
			return client.listByBusinessProcessHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByBusinessProcessCreateRequest creates the ListByBusinessProcess request.
func (client *BusinessProcessVersionsClient) listByBusinessProcessCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, businessProcessName string, options *BusinessProcessVersionsClientListByBusinessProcessOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/applications/{applicationName}/businessProcesses/{businessProcessName}/versions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	if applicationName == "" {
		return nil, errors.New("parameter applicationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{applicationName}", url.PathEscape(applicationName))
	if businessProcessName == "" {
		return nil, errors.New("parameter businessProcessName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{businessProcessName}", url.PathEscape(businessProcessName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	if options != nil && options.Top != nil {
		reqQP.Set("top", strconv.FormatInt(int64(*options.Top), 10))
	}
	if options != nil && options.Skip != nil {
		reqQP.Set("skip", strconv.FormatInt(int64(*options.Skip), 10))
	}
	if options != nil && options.Maxpagesize != nil {
		reqQP.Set("maxpagesize", strconv.FormatInt(int64(*options.Maxpagesize), 10))
	}
	if options != nil && options.Filter != nil {
		reqQP.Set("filter", *options.Filter)
	}
	if options != nil && options.Select != nil {
		for _, qv := range options.Select {
			reqQP.Add("select", qv)
		}
	}
	if options != nil && options.Expand != nil {
		for _, qv := range options.Expand {
			reqQP.Add("expand", qv)
		}
	}
	if options != nil && options.Orderby != nil {
		for _, qv := range options.Orderby {
			reqQP.Add("orderby", qv)
		}
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByBusinessProcessHandleResponse handles the ListByBusinessProcess response.
func (client *BusinessProcessVersionsClient) listByBusinessProcessHandleResponse(resp *http.Response) (BusinessProcessVersionsClientListByBusinessProcessResponse, error) {
	result := BusinessProcessVersionsClientListByBusinessProcessResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BusinessProcessVersionListResult); err != nil {
		return BusinessProcessVersionsClientListByBusinessProcessResponse{}, err
	}
	return result, nil
}
