//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdeploymentstacks

import "time"

// DebugSetting - The debug setting.
type DebugSetting struct {
	// Specifies the type of information to log for debugging. The permitted values are none, requestContent, responseContent,
	// or both requestContent and responseContent separated by a comma. The default is
	// none. When setting this value, carefully consider the type of information that is being passed in during deployment. By
	// logging information about the request or response, sensitive data that is
	// retrieved through the deployment operations could potentially be exposed.
	DetailLevel *string
}

// DenySettings - Defines how resources deployed by the deployment stack are locked.
type DenySettings struct {
	// REQUIRED; denySettings Mode.
	Mode *DenySettingsMode

	// DenySettings will be applied to child scopes.
	ApplyToChildScopes *bool

	// List of role-based management operations that are excluded from the denySettings. Up to 200 actions are permitted. If the
	// denySetting mode is set to 'denyWriteAndDelete', then the following actions
	// are automatically appended to 'excludedActions': '*/read' and 'Microsoft.Authorization/locks/delete'. If the denySetting
	// mode is set to 'denyDelete', then the following actions are automatically
	// appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will be removed.
	ExcludedActions []*string

	// List of AAD principal IDs excluded from the lock. Up to 5 principals are permitted.
	ExcludedPrincipals []*string
}

// DeploymentStack - Deployment stack object.
type DeploymentStack struct {
	// The location of the deployment stack. It cannot be changed after creation. It must be one of the supported Azure locations.
	Location *string

	// Deployment stack properties.
	Properties *DeploymentStackProperties

	// Deployment stack resource tags.
	Tags map[string]*string

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; Type of this resource.
	Type *string
}

// DeploymentStackListResult - List of deployment stacks.
type DeploymentStackListResult struct {
	// An array of deployment stacks.
	Value []*DeploymentStack

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string
}

// DeploymentStackProperties - Deployment stack properties.
type DeploymentStackProperties struct {
	// REQUIRED; Defines the behavior of resources that are not managed immediately after the stack is updated.
	ActionOnUnmanage *DeploymentStackPropertiesActionOnUnmanage

	// REQUIRED; Defines how resources deployed by the stack are locked.
	DenySettings *DenySettings

	// The debug setting of the deployment.
	DebugSetting *DebugSetting

	// The scope at which the initial deployment should be created. If a scope is not specified, it will default to the scope
	// of the deployment stack. Valid scopes are: management group (format:
	// '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format: '/subscriptions/{subscriptionId}'),
	// resource group (format:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
	DeploymentScope *string

	// Deployment stack description.
	Description *string

	// Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows
	// the OData error response format.).
	Error *ErrorResponse

	// Name and value pairs that define the deployment parameters for the template. Use this element when providing the parameter
	// values directly in the request, rather than linking to an existing parameter
	// file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or a well formed
	// JSON string.
	Parameters any

	// The URI of parameters file. Use this element to link to an existing parameters file. Use either the parametersLink property
	// or the parameters property, but not both.
	ParametersLink *ParametersLink

	// The template content. You use this element when you want to pass the template syntax directly in the request rather than
	// link to an existing template. It can be a JObject or well-formed JSON string.
	// Use either the templateLink property or the template property, but not both.
	Template any

	// The URI of the template. Use either the templateLink property or the template property, but not both.
	TemplateLink *TemplateLink

	// READ-ONLY; An array of resources that were deleted during the most recent update.
	DeletedResources []*ResourceReference

	// READ-ONLY; The resourceId of the deployment resource created by the deployment stack.
	DeploymentID *string

	// READ-ONLY; An array of resources that were detached during the most recent update.
	DetachedResources []*ResourceReference

	// READ-ONLY; The duration of the deployment stack update.
	Duration *string

	// READ-ONLY; An array of resources that failed to reach goal state during the most recent update.
	FailedResources []*ResourceReferenceExtended

	// READ-ONLY; The outputs of the underlying deployment.
	Outputs any

	// READ-ONLY; State of the deployment stack.
	ProvisioningState *DeploymentStackProvisioningState

	// READ-ONLY; An array of resources currently managed by the deployment stack.
	Resources []*ManagedResourceReference
}

// DeploymentStackPropertiesActionOnUnmanage - Defines the behavior of resources that are not managed immediately after the
// stack is updated.
type DeploymentStackPropertiesActionOnUnmanage struct {
	// REQUIRED; Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt
	// to delete the resource from Azure. Detach will leave the resource in it's current
	// state.
	Resources *DeploymentStacksDeleteDetachEnum

	// Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to
	// delete the resource from Azure. Detach will leave the resource in it's current
	// state.
	ManagementGroups *DeploymentStacksDeleteDetachEnum

	// Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to
	// delete the resource from Azure. Detach will leave the resource in it's current
	// state.
	ResourceGroups *DeploymentStacksDeleteDetachEnum
}

// DeploymentStackTemplateDefinition - Export Template specific properties of the Stack.
type DeploymentStackTemplateDefinition struct {
	// The template content. Use this element to pass the template syntax directly in the request rather than link to an existing
	// template. It can be a JObject or well-formed JSON string. Use either the
	// templateLink property or the template property, but not both.
	Template any

	// The URI of the template. Use either the templateLink property or the template property, but not both.
	TemplateLink *TemplateLink
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// ManagedResourceReference - The managed resource model.
type ManagedResourceReference struct {
	// denyAssignment settings applied to the resource.
	DenyStatus *DenyStatusMode

	// Current management state of the resource in the deployment stack.
	Status *ResourceStatusMode

	// READ-ONLY; The resourceId of a resource managed by the deployment stack.
	ID *string
}

// ParametersLink - Entity representing the reference to the deployment parameters.
type ParametersLink struct {
	// REQUIRED; The URI of the parameters file.
	URI *string

	// If included, must match the ContentVersion in the template.
	ContentVersion *string
}

// ResourceReference - The resource Id model.
type ResourceReference struct {
	// READ-ONLY; The resourceId of a resource managed by the deployment stack.
	ID *string
}

// ResourceReferenceExtended - The resource Id extended model.
type ResourceReferenceExtended struct {
	// Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows
	// the OData error response format.).
	Error *ErrorResponse

	// READ-ONLY; The resourceId of a resource managed by the deployment stack.
	ID *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TemplateLink - Entity representing the reference to the template.
type TemplateLink struct {
	// If included, must match the ContentVersion in the template.
	ContentVersion *string

	// The resource id of a Template Spec. Use either the id or uri property, but not both.
	ID *string

	// The query string (for example, a SAS token) to be used with the templateLink URI.
	QueryString *string

	// The relativePath property can be used to deploy a linked template at a location relative to the parent. If the parent template
	// was linked with a TemplateSpec, this will reference an artifact in the
	// TemplateSpec. If the parent was linked with a URI, the child deployment will be a combination of the parent and relativePath
	// URIs
	RelativePath *string

	// The URI of the template to deploy. Use either the uri or id property, but not both.
	URI *string
}
