//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpolicy

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// VariableValuesClient contains the methods for the VariableValues group.
// Don't use this type directly, use NewVariableValuesClient() instead.
type VariableValuesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewVariableValuesClient creates a new instance of VariableValuesClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewVariableValuesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*VariableValuesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &VariableValuesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - This operation creates or updates a variable value with the given subscription and name for a given variable.
// Variable values are scoped to the variable for which they are created for.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - variableName - The name of the variable to operate on.
//   - variableValueName - The name of the variable value to operate on.
//   - parameters - Parameters for the variable value.
//   - options - VariableValuesClientCreateOrUpdateOptions contains the optional parameters for the VariableValuesClient.CreateOrUpdate
//     method.
func (client *VariableValuesClient) CreateOrUpdate(ctx context.Context, variableName string, variableValueName string, parameters VariableValue, options *VariableValuesClientCreateOrUpdateOptions) (VariableValuesClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "VariableValuesClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, variableName, variableValueName, parameters, options)
	if err != nil {
		return VariableValuesClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VariableValuesClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return VariableValuesClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *VariableValuesClient) createOrUpdateCreateRequest(ctx context.Context, variableName string, variableValueName string, parameters VariableValue, options *VariableValuesClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}/values/{variableValueName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if variableName == "" {
		return nil, errors.New("parameter variableName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableName}", url.PathEscape(variableName))
	if variableValueName == "" {
		return nil, errors.New("parameter variableValueName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableValueName}", url.PathEscape(variableValueName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *VariableValuesClient) createOrUpdateHandleResponse(resp *http.Response) (VariableValuesClientCreateOrUpdateResponse, error) {
	result := VariableValuesClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VariableValue); err != nil {
		return VariableValuesClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateAtManagementGroup - This operation creates or updates a variable value with the given management group and
// name for a given variable. Variable values are scoped to the variable for which they are created for.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - managementGroupID - The ID of the management group.
//   - variableName - The name of the variable to operate on.
//   - variableValueName - The name of the variable value to operate on.
//   - parameters - Parameters for the variable value.
//   - options - VariableValuesClientCreateOrUpdateAtManagementGroupOptions contains the optional parameters for the VariableValuesClient.CreateOrUpdateAtManagementGroup
//     method.
func (client *VariableValuesClient) CreateOrUpdateAtManagementGroup(ctx context.Context, managementGroupID string, variableName string, variableValueName string, parameters VariableValue, options *VariableValuesClientCreateOrUpdateAtManagementGroupOptions) (VariableValuesClientCreateOrUpdateAtManagementGroupResponse, error) {
	var err error
	const operationName = "VariableValuesClient.CreateOrUpdateAtManagementGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateAtManagementGroupCreateRequest(ctx, managementGroupID, variableName, variableValueName, parameters, options)
	if err != nil {
		return VariableValuesClientCreateOrUpdateAtManagementGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VariableValuesClientCreateOrUpdateAtManagementGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return VariableValuesClientCreateOrUpdateAtManagementGroupResponse{}, err
	}
	resp, err := client.createOrUpdateAtManagementGroupHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateAtManagementGroupCreateRequest creates the CreateOrUpdateAtManagementGroup request.
func (client *VariableValuesClient) createOrUpdateAtManagementGroupCreateRequest(ctx context.Context, managementGroupID string, variableName string, variableValueName string, parameters VariableValue, options *VariableValuesClientCreateOrUpdateAtManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables/{variableName}/values/{variableValueName}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if variableName == "" {
		return nil, errors.New("parameter variableName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableName}", url.PathEscape(variableName))
	if variableValueName == "" {
		return nil, errors.New("parameter variableValueName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableValueName}", url.PathEscape(variableValueName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateAtManagementGroupHandleResponse handles the CreateOrUpdateAtManagementGroup response.
func (client *VariableValuesClient) createOrUpdateAtManagementGroupHandleResponse(resp *http.Response) (VariableValuesClientCreateOrUpdateAtManagementGroupResponse, error) {
	result := VariableValuesClientCreateOrUpdateAtManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VariableValue); err != nil {
		return VariableValuesClientCreateOrUpdateAtManagementGroupResponse{}, err
	}
	return result, nil
}

// Delete - This operation deletes a variable value, given its name, the subscription it was created in, and the variable
// it belongs to. The scope of a variable value is the part of its ID preceding
// '/providers/Microsoft.Authorization/variables/{variableName}'.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - variableName - The name of the variable to operate on.
//   - variableValueName - The name of the variable value to operate on.
//   - options - VariableValuesClientDeleteOptions contains the optional parameters for the VariableValuesClient.Delete method.
func (client *VariableValuesClient) Delete(ctx context.Context, variableName string, variableValueName string, options *VariableValuesClientDeleteOptions) (VariableValuesClientDeleteResponse, error) {
	var err error
	const operationName = "VariableValuesClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, variableName, variableValueName, options)
	if err != nil {
		return VariableValuesClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VariableValuesClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return VariableValuesClientDeleteResponse{}, err
	}
	return VariableValuesClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *VariableValuesClient) deleteCreateRequest(ctx context.Context, variableName string, variableValueName string, options *VariableValuesClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}/values/{variableValueName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if variableName == "" {
		return nil, errors.New("parameter variableName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableName}", url.PathEscape(variableName))
	if variableValueName == "" {
		return nil, errors.New("parameter variableValueName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableValueName}", url.PathEscape(variableValueName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteAtManagementGroup - This operation deletes a variable value, given its name, the management group it was created
// in, and the variable it belongs to. The scope of a variable value is the part of its ID preceding
// '/providers/Microsoft.Authorization/variables/{variableName}'.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - managementGroupID - The ID of the management group.
//   - variableName - The name of the variable to operate on.
//   - variableValueName - The name of the variable value to operate on.
//   - options - VariableValuesClientDeleteAtManagementGroupOptions contains the optional parameters for the VariableValuesClient.DeleteAtManagementGroup
//     method.
func (client *VariableValuesClient) DeleteAtManagementGroup(ctx context.Context, managementGroupID string, variableName string, variableValueName string, options *VariableValuesClientDeleteAtManagementGroupOptions) (VariableValuesClientDeleteAtManagementGroupResponse, error) {
	var err error
	const operationName = "VariableValuesClient.DeleteAtManagementGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteAtManagementGroupCreateRequest(ctx, managementGroupID, variableName, variableValueName, options)
	if err != nil {
		return VariableValuesClientDeleteAtManagementGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VariableValuesClientDeleteAtManagementGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return VariableValuesClientDeleteAtManagementGroupResponse{}, err
	}
	return VariableValuesClientDeleteAtManagementGroupResponse{}, nil
}

// deleteAtManagementGroupCreateRequest creates the DeleteAtManagementGroup request.
func (client *VariableValuesClient) deleteAtManagementGroupCreateRequest(ctx context.Context, managementGroupID string, variableName string, variableValueName string, options *VariableValuesClientDeleteAtManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables/{variableName}/values/{variableValueName}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if variableName == "" {
		return nil, errors.New("parameter variableName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableName}", url.PathEscape(variableName))
	if variableValueName == "" {
		return nil, errors.New("parameter variableValueName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableValueName}", url.PathEscape(variableValueName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - This operation retrieves a single variable value; given its name, subscription it was created at and the variable
// it's created for.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - variableName - The name of the variable to operate on.
//   - variableValueName - The name of the variable value to operate on.
//   - options - VariableValuesClientGetOptions contains the optional parameters for the VariableValuesClient.Get method.
func (client *VariableValuesClient) Get(ctx context.Context, variableName string, variableValueName string, options *VariableValuesClientGetOptions) (VariableValuesClientGetResponse, error) {
	var err error
	const operationName = "VariableValuesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, variableName, variableValueName, options)
	if err != nil {
		return VariableValuesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VariableValuesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return VariableValuesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *VariableValuesClient) getCreateRequest(ctx context.Context, variableName string, variableValueName string, options *VariableValuesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}/values/{variableValueName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if variableName == "" {
		return nil, errors.New("parameter variableName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableName}", url.PathEscape(variableName))
	if variableValueName == "" {
		return nil, errors.New("parameter variableValueName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableValueName}", url.PathEscape(variableValueName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *VariableValuesClient) getHandleResponse(resp *http.Response) (VariableValuesClientGetResponse, error) {
	result := VariableValuesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VariableValue); err != nil {
		return VariableValuesClientGetResponse{}, err
	}
	return result, nil
}

// GetAtManagementGroup - This operation retrieves a single variable value; given its name, management group it was created
// at and the variable it's created for.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - managementGroupID - The ID of the management group.
//   - variableName - The name of the variable to operate on.
//   - variableValueName - The name of the variable value to operate on.
//   - options - VariableValuesClientGetAtManagementGroupOptions contains the optional parameters for the VariableValuesClient.GetAtManagementGroup
//     method.
func (client *VariableValuesClient) GetAtManagementGroup(ctx context.Context, managementGroupID string, variableName string, variableValueName string, options *VariableValuesClientGetAtManagementGroupOptions) (VariableValuesClientGetAtManagementGroupResponse, error) {
	var err error
	const operationName = "VariableValuesClient.GetAtManagementGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAtManagementGroupCreateRequest(ctx, managementGroupID, variableName, variableValueName, options)
	if err != nil {
		return VariableValuesClientGetAtManagementGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VariableValuesClientGetAtManagementGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return VariableValuesClientGetAtManagementGroupResponse{}, err
	}
	resp, err := client.getAtManagementGroupHandleResponse(httpResp)
	return resp, err
}

// getAtManagementGroupCreateRequest creates the GetAtManagementGroup request.
func (client *VariableValuesClient) getAtManagementGroupCreateRequest(ctx context.Context, managementGroupID string, variableName string, variableValueName string, options *VariableValuesClientGetAtManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables/{variableName}/values/{variableValueName}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if variableName == "" {
		return nil, errors.New("parameter variableName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableName}", url.PathEscape(variableName))
	if variableValueName == "" {
		return nil, errors.New("parameter variableValueName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableValueName}", url.PathEscape(variableValueName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAtManagementGroupHandleResponse handles the GetAtManagementGroup response.
func (client *VariableValuesClient) getAtManagementGroupHandleResponse(resp *http.Response) (VariableValuesClientGetAtManagementGroupResponse, error) {
	result := VariableValuesClientGetAtManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VariableValue); err != nil {
		return VariableValuesClientGetAtManagementGroupResponse{}, err
	}
	return result, nil
}

// NewListPager - This operation retrieves the list of all variable values associated with the given variable that is at a
// subscription level.
//
// Generated from API version 2022-08-01-preview
//   - variableName - The name of the variable to operate on.
//   - options - VariableValuesClientListOptions contains the optional parameters for the VariableValuesClient.NewListPager method.
func (client *VariableValuesClient) NewListPager(variableName string, options *VariableValuesClientListOptions) *runtime.Pager[VariableValuesClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[VariableValuesClientListResponse]{
		More: func(page VariableValuesClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *VariableValuesClientListResponse) (VariableValuesClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "VariableValuesClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, variableName, options)
			}, nil)
			if err != nil {
				return VariableValuesClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *VariableValuesClient) listCreateRequest(ctx context.Context, variableName string, options *VariableValuesClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}/values"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if variableName == "" {
		return nil, errors.New("parameter variableName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableName}", url.PathEscape(variableName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *VariableValuesClient) listHandleResponse(resp *http.Response) (VariableValuesClientListResponse, error) {
	result := VariableValuesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VariableValueListResult); err != nil {
		return VariableValuesClientListResponse{}, err
	}
	return result, nil
}

// NewListForManagementGroupPager - This operation retrieves the list of all variable values applicable the variable indicated
// at the management group scope.
//
// Generated from API version 2022-08-01-preview
//   - managementGroupID - The ID of the management group.
//   - variableName - The name of the variable to operate on.
//   - options - VariableValuesClientListForManagementGroupOptions contains the optional parameters for the VariableValuesClient.NewListForManagementGroupPager
//     method.
func (client *VariableValuesClient) NewListForManagementGroupPager(managementGroupID string, variableName string, options *VariableValuesClientListForManagementGroupOptions) *runtime.Pager[VariableValuesClientListForManagementGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[VariableValuesClientListForManagementGroupResponse]{
		More: func(page VariableValuesClientListForManagementGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *VariableValuesClientListForManagementGroupResponse) (VariableValuesClientListForManagementGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "VariableValuesClient.NewListForManagementGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listForManagementGroupCreateRequest(ctx, managementGroupID, variableName, options)
			}, nil)
			if err != nil {
				return VariableValuesClientListForManagementGroupResponse{}, err
			}
			return client.listForManagementGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listForManagementGroupCreateRequest creates the ListForManagementGroup request.
func (client *VariableValuesClient) listForManagementGroupCreateRequest(ctx context.Context, managementGroupID string, variableName string, options *VariableValuesClientListForManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables/{variableName}/values"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if variableName == "" {
		return nil, errors.New("parameter variableName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableName}", url.PathEscape(variableName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listForManagementGroupHandleResponse handles the ListForManagementGroup response.
func (client *VariableValuesClient) listForManagementGroupHandleResponse(resp *http.Response) (VariableValuesClientListForManagementGroupResponse, error) {
	result := VariableValuesClientListForManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VariableValueListResult); err != nil {
		return VariableValuesClientListForManagementGroupResponse{}, err
	}
	return result, nil
}
