//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armsubscriptions"
	"net/http"
)

// TenantsServer is a fake server for instances of the armsubscriptions.TenantsClient type.
type TenantsServer struct {
	// NewListPager is the fake for method TenantsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armsubscriptions.TenantsClientListOptions) (resp azfake.PagerResponder[armsubscriptions.TenantsClientListResponse])
}

// NewTenantsServerTransport creates a new instance of TenantsServerTransport with the provided implementation.
// The returned TenantsServerTransport instance is connected to an instance of armsubscriptions.TenantsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTenantsServerTransport(srv *TenantsServer) *TenantsServerTransport {
	return &TenantsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armsubscriptions.TenantsClientListResponse]](),
	}
}

// TenantsServerTransport connects instances of armsubscriptions.TenantsClient to instances of TenantsServer.
// Don't use this type directly, use NewTenantsServerTransport instead.
type TenantsServerTransport struct {
	srv          *TenantsServer
	newListPager *tracker[azfake.PagerResponder[armsubscriptions.TenantsClientListResponse]]
}

// Do implements the policy.Transporter interface for TenantsServerTransport.
func (t *TenantsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TenantsClient.NewListPager":
		resp, err = t.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TenantsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := t.newListPager.get(req)
	if newListPager == nil {
		resp := t.srv.NewListPager(nil)
		newListPager = &resp
		t.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsubscriptions.TenantsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		t.newListPager.remove(req)
	}
	return resp, nil
}
