//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sphere/armsphere"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// CertificatesServer is a fake server for instances of the armsphere.CertificatesClient type.
type CertificatesServer struct {
	// Get is the fake for method CertificatesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, catalogName string, serialNumber string, options *armsphere.CertificatesClientGetOptions) (resp azfake.Responder[armsphere.CertificatesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByCatalogPager is the fake for method CertificatesClient.NewListByCatalogPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByCatalogPager func(resourceGroupName string, catalogName string, options *armsphere.CertificatesClientListByCatalogOptions) (resp azfake.PagerResponder[armsphere.CertificatesClientListByCatalogResponse])

	// RetrieveCertChain is the fake for method CertificatesClient.RetrieveCertChain
	// HTTP status codes to indicate success: http.StatusOK
	RetrieveCertChain func(ctx context.Context, resourceGroupName string, catalogName string, serialNumber string, options *armsphere.CertificatesClientRetrieveCertChainOptions) (resp azfake.Responder[armsphere.CertificatesClientRetrieveCertChainResponse], errResp azfake.ErrorResponder)

	// RetrieveProofOfPossessionNonce is the fake for method CertificatesClient.RetrieveProofOfPossessionNonce
	// HTTP status codes to indicate success: http.StatusOK
	RetrieveProofOfPossessionNonce func(ctx context.Context, resourceGroupName string, catalogName string, serialNumber string, proofOfPossessionNonceRequest armsphere.ProofOfPossessionNonceRequest, options *armsphere.CertificatesClientRetrieveProofOfPossessionNonceOptions) (resp azfake.Responder[armsphere.CertificatesClientRetrieveProofOfPossessionNonceResponse], errResp azfake.ErrorResponder)
}

// NewCertificatesServerTransport creates a new instance of CertificatesServerTransport with the provided implementation.
// The returned CertificatesServerTransport instance is connected to an instance of armsphere.CertificatesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCertificatesServerTransport(srv *CertificatesServer) *CertificatesServerTransport {
	return &CertificatesServerTransport{
		srv:                   srv,
		newListByCatalogPager: newTracker[azfake.PagerResponder[armsphere.CertificatesClientListByCatalogResponse]](),
	}
}

// CertificatesServerTransport connects instances of armsphere.CertificatesClient to instances of CertificatesServer.
// Don't use this type directly, use NewCertificatesServerTransport instead.
type CertificatesServerTransport struct {
	srv                   *CertificatesServer
	newListByCatalogPager *tracker[azfake.PagerResponder[armsphere.CertificatesClientListByCatalogResponse]]
}

// Do implements the policy.Transporter interface for CertificatesServerTransport.
func (c *CertificatesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CertificatesClient.Get":
		resp, err = c.dispatchGet(req)
	case "CertificatesClient.NewListByCatalogPager":
		resp, err = c.dispatchNewListByCatalogPager(req)
	case "CertificatesClient.RetrieveCertChain":
		resp, err = c.dispatchRetrieveCertChain(req)
	case "CertificatesClient.RetrieveProofOfPossessionNonce":
		resp, err = c.dispatchRetrieveProofOfPossessionNonce(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CertificatesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureSphere/catalogs/(?P<catalogName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates/(?P<serialNumber>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	catalogNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("catalogName")])
	if err != nil {
		return nil, err
	}
	serialNumberParam, err := url.PathUnescape(matches[regex.SubexpIndex("serialNumber")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, catalogNameParam, serialNumberParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Certificate, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificatesServerTransport) dispatchNewListByCatalogPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByCatalogPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByCatalogPager not implemented")}
	}
	newListByCatalogPager := c.newListByCatalogPager.get(req)
	if newListByCatalogPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureSphere/catalogs/(?P<catalogName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		maxpagesizeUnescaped, err := url.QueryUnescape(qp.Get("$maxpagesize"))
		if err != nil {
			return nil, err
		}
		maxpagesizeParam, err := parseOptional(maxpagesizeUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		catalogNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("catalogName")])
		if err != nil {
			return nil, err
		}
		var options *armsphere.CertificatesClientListByCatalogOptions
		if filterParam != nil || topParam != nil || skipParam != nil || maxpagesizeParam != nil {
			options = &armsphere.CertificatesClientListByCatalogOptions{
				Filter:      filterParam,
				Top:         topParam,
				Skip:        skipParam,
				Maxpagesize: maxpagesizeParam,
			}
		}
		resp := c.srv.NewListByCatalogPager(resourceGroupNameParam, catalogNameParam, options)
		newListByCatalogPager = &resp
		c.newListByCatalogPager.add(req, newListByCatalogPager)
		server.PagerResponderInjectNextLinks(newListByCatalogPager, req, func(page *armsphere.CertificatesClientListByCatalogResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByCatalogPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByCatalogPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByCatalogPager) {
		c.newListByCatalogPager.remove(req)
	}
	return resp, nil
}

func (c *CertificatesServerTransport) dispatchRetrieveCertChain(req *http.Request) (*http.Response, error) {
	if c.srv.RetrieveCertChain == nil {
		return nil, &nonRetriableError{errors.New("fake for method RetrieveCertChain not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureSphere/catalogs/(?P<catalogName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates/(?P<serialNumber>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/retrieveCertChain`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	catalogNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("catalogName")])
	if err != nil {
		return nil, err
	}
	serialNumberParam, err := url.PathUnescape(matches[regex.SubexpIndex("serialNumber")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.RetrieveCertChain(req.Context(), resourceGroupNameParam, catalogNameParam, serialNumberParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CertificateChainResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificatesServerTransport) dispatchRetrieveProofOfPossessionNonce(req *http.Request) (*http.Response, error) {
	if c.srv.RetrieveProofOfPossessionNonce == nil {
		return nil, &nonRetriableError{errors.New("fake for method RetrieveProofOfPossessionNonce not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureSphere/catalogs/(?P<catalogName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates/(?P<serialNumber>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/retrieveProofOfPossessionNonce`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsphere.ProofOfPossessionNonceRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	catalogNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("catalogName")])
	if err != nil {
		return nil, err
	}
	serialNumberParam, err := url.PathUnescape(matches[regex.SubexpIndex("serialNumber")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.RetrieveProofOfPossessionNonce(req.Context(), resourceGroupNameParam, catalogNameParam, serialNumberParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProofOfPossessionNonceResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
