/*
#   iswr.h: inspired by libsamplerate's callback api
#   Copyright (C) 2025 Stephen Fairchild (s-fairchild@users.sourceforge.net)
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program in the file entitled COPYING.
#   If not, see <http://www.gnu.org/licenses/>.
*/

#include <samplerate.h>

typedef void ISWR_STATE;

ISWR_STATE *iswr_callback_new(src_callback_t func,
                    int converter_type, int channels,
                    int *error, void* cb_data);

ISWR_STATE *iswr_delete(ISWR_STATE *state);

long iswr_callback_read(ISWR_STATE *state, double src_ratio,
                    long frames, float *data);

int iswr_reset(ISWR_STATE *state);
int iswr_set_ratio(ISWR_STATE *state, double new_ratio);
int iswr_error(ISWR_STATE *state);
