# getDirectoryToWatchFailedLookupLocationFromTypeRoot

When watched typeRoot handler is invoked, this method determines the directory for which the failedLookupLocation would need to be invalidated.
Since this is invoked only when watching default typeRoot and is used to handle flaky directory watchers, this is used as a fail safe where if failed lookup starts with returned directory we will invalidate that resolution.

## Testing for Posix root: /

## RootDirForResolution: /

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /                                                                                        |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /                                                                                        |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /                                                                                        |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /                                                                                        |
| /users/username/folderAtRoot/node_modules/@types                                         | /                                                                                        |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /                                                                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /                                                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /                                                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /                                                                                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /                                                                                        |
| /user/username/folderAtRoot/node_modules/@types                                          | /                                                                                        |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /                                                                                        |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /                                                                                        |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /                                                                                        |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /                                                                                        |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /                                                                                        |
| /usr/username/folderAtRoot/node_modules/@types                                           | /                                                                                        |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /                                                                                        |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /                                                                                        |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /                                                                                        |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /                                                                                        |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /                                                                                        |
| /home/username/folderAtRoot/node_modules/@types                                          | /                                                                                        |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /                                                                                        |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /                                                                                        |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /                                                                                        |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /                                                                                        |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /                                                                                        |

## RootDirForResolution: /folderAtRoot

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot                                                                            |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot                                                                            |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot                                                                            |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot                                                                            |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /folderAtRoot/folder1

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1                                                                    |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1                                                                    |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1                                                                    |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1                                                                    |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /folderAtRoot/folder1/folder2

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2                                                            |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2                                                            |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2                                                            |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2                                                            |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3                                                    |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3                                                    |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3                                                    |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4                                            |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4                                            |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5                                    |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /users

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users                                                                                   |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users                                                                                   |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users                                                                                   |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users                                                                                   |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users                                                                                   |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users                                                                                   |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /users/username

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username                                                                          |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username                                                                          |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username                                                                          |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username                                                                          |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username                                                                          |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username                                                                          |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /users/username/folderAtRoot

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot                                                             |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot                                                             |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot                                                             |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot                                                             |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot                                                             |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot                                                             |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /users/username/folderAtRoot/folder1

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1                                                     |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1                                                     |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1                                                     |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1                                                     |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1                                                     |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2                                             |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2                                             |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2                                             |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2                                             |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3                                     |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3                                     |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3                                     |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                             |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                             |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                     |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /user

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user                                                                                    |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user                                                                                    |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user                                                                                    |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user                                                                                    |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user                                                                                    |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user                                                                                    |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /user/username

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username                                                                           |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username                                                                           |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username                                                                           |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username                                                                           |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /user/username/folderAtRoot

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot                                                              |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot                                                              |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot                                                              |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /user/username/folderAtRoot/folder1

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1                                                      |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1                                                      |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1                                                      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1                                                      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1                                                      |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2                                              |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3                                      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3                                      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3                                      |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                              |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                      |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /usr

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr                                                                                     |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr                                                                                     |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr                                                                                     |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr                                                                                     |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr                                                                                     |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr                                                                                     |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /usr/username

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username                                                                            |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username                                                                            |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username                                                                            |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username                                                                            |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username                                                                            |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username                                                                            |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /usr/username/folderAtRoot

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot                                                               |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot                                                               |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot                                                               |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot                                                               |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot                                                               |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot                                                               |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /usr/username/folderAtRoot/folder1

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1                                                       |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1                                                       |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1                                                       |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1                                                       |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1                                                       |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2                                               |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2                                               |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2                                               |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2                                               |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3                                       |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3                                       |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3                                       |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                               |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                               |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                       |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |

## RootDirForResolution: /home

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home                                                                                    |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home                                                                                    |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home                                                                                    |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home                                                                                    |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home                                                                                    |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home                                                                                    |

## RootDirForResolution: /home/username

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username                                                                           |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username                                                                           |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username                                                                           |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username                                                                           |

## RootDirForResolution: /home/username/folderAtRoot

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot                                                              |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot                                                              |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot                                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1                                                      |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1                                                      |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1                                                      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1                                                      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1                                                      |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3                                      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3                                      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3                                      |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                      |
| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| /folderAtRoot/folder1/folder2/node_modules/@types                                        | /folderAtRoot/folder1/folder2/node_modules                                               |
| /folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | /folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| /folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | /folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| /users/username/folderAtRoot/node_modules/@types                                         | /users/username/folderAtRoot/node_modules                                                |
| /users/username/folderAtRoot/folder1/node_modules/@types                                 | /users/username/folderAtRoot/folder1/node_modules                                        |
| /users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | /users/username/folderAtRoot/folder1/folder2/node_modules                                |
| /users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | /users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| /user/username/folderAtRoot/node_modules/@types                                          | /user/username/folderAtRoot/node_modules                                                 |
| /user/username/folderAtRoot/folder1/node_modules/@types                                  | /user/username/folderAtRoot/folder1/node_modules                                         |
| /user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| /usr/username/folderAtRoot/node_modules/@types                                           | /usr/username/folderAtRoot/node_modules                                                  |
| /usr/username/folderAtRoot/folder1/node_modules/@types                                   | /usr/username/folderAtRoot/folder1/node_modules                                          |
| /usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | /usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | /usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| /home/username/folderAtRoot/node_modules/@types                                          | /home/username/folderAtRoot/node_modules                                                 |
| /home/username/folderAtRoot/folder1/node_modules/@types                                  | /home/username/folderAtRoot/folder1/node_modules                                         |
| /home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | /home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | /home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                      |

