# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_discriminator, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class Resource(_model_base.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.databasewatcher.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long"""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.databasewatcher.models.SystemData
    """


class AlertRuleResource(ProxyResource):
    """Concrete proxy resource types can be created by aliasing this type using a specific property
    type.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.databasewatcher.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.databasewatcher.models.AlertRuleResourceProperties
    """

    properties: Optional["_models.AlertRuleResourceProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AlertRuleResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AlertRuleResourceProperties(_model_base.Model):
    """The generic properties of the alert rule proxy resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar alert_rule_resource_id: The resource ID of the alert rule resource. Required.
    :vartype alert_rule_resource_id: str
    :ivar created_with_properties: The properties with which the alert rule resource was created.
     Required. Known values are: "CreatedWithActionGroup" and "None".
    :vartype created_with_properties: str or
     ~azure.mgmt.databasewatcher.models.AlertRuleCreationProperties
    :ivar creation_time: The creation time of the alert rule resource. Required.
    :vartype creation_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the alert rule resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.databasewatcher.models.ResourceProvisioningState
    :ivar alert_rule_template_id: The template ID associated with alert rule resource. Required.
    :vartype alert_rule_template_id: str
    :ivar alert_rule_template_version: The alert rule template version. Required.
    :vartype alert_rule_template_version: str
    """

    alert_rule_resource_id: str = rest_field(name="alertRuleResourceId")
    """The resource ID of the alert rule resource. Required."""
    created_with_properties: Union[str, "_models.AlertRuleCreationProperties"] = rest_field(
        name="createdWithProperties"
    )
    """The properties with which the alert rule resource was created. Required. Known values are:
     \"CreatedWithActionGroup\" and \"None\"."""
    creation_time: datetime.datetime = rest_field(name="creationTime", format="rfc3339")
    """The creation time of the alert rule resource. Required."""
    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the alert rule resource. Known values are: \"Succeeded\", \"Failed\",
     and \"Canceled\"."""
    alert_rule_template_id: str = rest_field(name="alertRuleTemplateId")
    """The template ID associated with alert rule resource. Required."""
    alert_rule_template_version: str = rest_field(name="alertRuleTemplateVersion")
    """The alert rule template version. Required."""

    @overload
    def __init__(
        self,
        *,
        alert_rule_resource_id: str,
        created_with_properties: Union[str, "_models.AlertRuleCreationProperties"],
        creation_time: datetime.datetime,
        alert_rule_template_id: str,
        alert_rule_template_version: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Datastore(_model_base.Model):
    """The properties of a data store.


    :ivar adx_cluster_resource_id: The Azure resource ID of an Azure Data Explorer cluster.
    :vartype adx_cluster_resource_id: str
    :ivar kusto_cluster_display_name: The Kusto cluster display name.
    :vartype kusto_cluster_display_name: str
    :ivar kusto_cluster_uri: The Kusto cluster URI. Required.
    :vartype kusto_cluster_uri: str
    :ivar kusto_data_ingestion_uri: The Kusto data ingestion URI. Required.
    :vartype kusto_data_ingestion_uri: str
    :ivar kusto_database_name: The name of a Kusto database. Required.
    :vartype kusto_database_name: str
    :ivar kusto_management_url: The Kusto management URL. Required.
    :vartype kusto_management_url: str
    :ivar kusto_offering_type: The type of a Kusto offering. Required. Known values are: "adx",
     "free", and "fabric".
    :vartype kusto_offering_type: str or ~azure.mgmt.databasewatcher.models.KustoOfferingType
    """

    adx_cluster_resource_id: Optional[str] = rest_field(name="adxClusterResourceId")
    """The Azure resource ID of an Azure Data Explorer cluster."""
    kusto_cluster_display_name: Optional[str] = rest_field(name="kustoClusterDisplayName")
    """The Kusto cluster display name."""
    kusto_cluster_uri: str = rest_field(name="kustoClusterUri")
    """The Kusto cluster URI. Required."""
    kusto_data_ingestion_uri: str = rest_field(name="kustoDataIngestionUri")
    """The Kusto data ingestion URI. Required."""
    kusto_database_name: str = rest_field(name="kustoDatabaseName")
    """The name of a Kusto database. Required."""
    kusto_management_url: str = rest_field(name="kustoManagementUrl")
    """The Kusto management URL. Required."""
    kusto_offering_type: Union[str, "_models.KustoOfferingType"] = rest_field(name="kustoOfferingType")
    """The type of a Kusto offering. Required. Known values are: \"adx\", \"free\", and \"fabric\"."""

    @overload
    def __init__(
        self,
        *,
        kusto_cluster_uri: str,
        kusto_data_ingestion_uri: str,
        kusto_database_name: str,
        kusto_management_url: str,
        kusto_offering_type: Union[str, "_models.KustoOfferingType"],
        adx_cluster_resource_id: Optional[str] = None,
        kusto_cluster_display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.databasewatcher.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.databasewatcher.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.databasewatcher.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field()
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthValidation(ProxyResource):
    """Concrete proxy resource types can be created by aliasing this type using a specific property
    type.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.databasewatcher.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.databasewatcher.models.HealthValidationProperties
    """

    properties: Optional["_models.HealthValidationProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.HealthValidationProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthValidationProperties(_model_base.Model):
    """The generic properties of the health validation resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar start_time: The start time of health validation, in UTC. Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of health validation, in UTC. Required.
    :vartype end_time: ~datetime.datetime
    :ivar status: The current health validation status. Required. Known values are: "NotStarted",
     "Running", "Succeeded", "Failed", "Canceled", and "TimedOut".
    :vartype status: str or ~azure.mgmt.databasewatcher.models.ValidationStatus
    :ivar issues: The list of issues found by health validation. Required.
    :vartype issues: list[~azure.mgmt.databasewatcher.models.ValidationIssue]
    :ivar provisioning_state: The provisioning state of the health validation resource. Known
     values are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.databasewatcher.models.ResourceProvisioningState
    """

    start_time: datetime.datetime = rest_field(name="startTime", visibility=["read"], format="rfc3339")
    """The start time of health validation, in UTC. Required."""
    end_time: datetime.datetime = rest_field(name="endTime", visibility=["read"], format="rfc3339")
    """The end time of health validation, in UTC. Required."""
    status: Union[str, "_models.ValidationStatus"] = rest_field(visibility=["read"])
    """The current health validation status. Required. Known values are: \"NotStarted\", \"Running\",
     \"Succeeded\", \"Failed\", \"Canceled\", and \"TimedOut\"."""
    issues: List["_models.ValidationIssue"] = rest_field(visibility=["read"])
    """The list of issues found by health validation. Required."""
    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the health validation resource. Known values are: \"Succeeded\",
     \"Failed\", and \"Canceled\"."""


class ManagedServiceIdentityV4(_model_base.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.databasewatcher.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.databasewatcher.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field()
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned, UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities"
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.databasewatcher.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.databasewatcher.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.databasewatcher.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field()
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class SharedPrivateLinkResource(ProxyResource):
    """Concrete proxy resource types can be created by aliasing this type using a specific property
    type.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.databasewatcher.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.databasewatcher.models.SharedPrivateLinkResourceProperties
    """

    properties: Optional["_models.SharedPrivateLinkResourceProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SharedPrivateLinkResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SharedPrivateLinkResourceProperties(_model_base.Model):
    """The generic properties of a Shared Private Link resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar private_link_resource_id: The resource ID of the resource the shared private link
     resource is for. Required.
    :vartype private_link_resource_id: str
    :ivar group_id: The group id from the provider of resource the shared private link resource is
     for. Required.
    :vartype group_id: str
    :ivar request_message: The request message for requesting approval of the shared private link
     resource. Required.
    :vartype request_message: str
    :ivar dns_zone: The DNS zone to be included in the DNS name of the shared private link. Value
     is required for Azure Data Explorer clusters and SQL managed instances. The value to use is the
     second segment of the host FQDN name of the resource that the shared private link resource is
     for.
    :vartype dns_zone: str
    :ivar status: Status of the shared private link resource. Can be Pending, Approved, Rejected or
     Disconnected. Known values are: "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.databasewatcher.models.SharedPrivateLinkResourceStatus
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.databasewatcher.models.ResourceProvisioningState
    """

    private_link_resource_id: str = rest_field(name="privateLinkResourceId")
    """The resource ID of the resource the shared private link resource is for. Required."""
    group_id: str = rest_field(name="groupId")
    """The group id from the provider of resource the shared private link resource is for. Required."""
    request_message: str = rest_field(name="requestMessage")
    """The request message for requesting approval of the shared private link resource. Required."""
    dns_zone: Optional[str] = rest_field(name="dnsZone")
    """The DNS zone to be included in the DNS name of the shared private link. Value is required for
     Azure Data Explorer clusters and SQL managed instances. The value to use is the second segment
     of the host FQDN name of the resource that the shared private link resource is for."""
    status: Optional[Union[str, "_models.SharedPrivateLinkResourceStatus"]] = rest_field(visibility=["read"])
    """Status of the shared private link resource. Can be Pending, Approved, Rejected or Disconnected.
     Known values are: \"Pending\", \"Approved\", \"Rejected\", and \"Disconnected\"."""
    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        private_link_resource_id: str,
        group_id: str,
        request_message: str,
        dns_zone: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TargetProperties(_model_base.Model):
    """The generic properties of a target.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SqlDbSingleDatabaseTargetProperties, SqlDbElasticPoolTargetProperties, SqlMiTargetProperties

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar target_type: Discriminator property for TargetProperties. Required. Default value is
     None.
    :vartype target_type: str
    :ivar target_authentication_type: The type of authentication to use when connecting to a
     target. Required. Known values are: "Aad" and "Sql".
    :vartype target_authentication_type: str or
     ~azure.mgmt.databasewatcher.models.TargetAuthenticationType
    :ivar target_vault: To use SQL authentication when connecting to targets, specify the vault
     where the login name and password secrets are stored.
    :vartype target_vault: ~azure.mgmt.databasewatcher.models.VaultSecret
    :ivar connection_server_name: The server name to use in the connection string when connecting
     to a target. Port number and instance name must be specified separately. Required.
    :vartype connection_server_name: str
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.databasewatcher.models.ResourceProvisioningState
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    target_type: str = rest_discriminator(name="targetType")
    """Discriminator property for TargetProperties. Required. Default value is None."""
    target_authentication_type: Union[str, "_models.TargetAuthenticationType"] = rest_field(
        name="targetAuthenticationType"
    )
    """The type of authentication to use when connecting to a target. Required. Known values are:
     \"Aad\" and \"Sql\"."""
    target_vault: Optional["_models.VaultSecret"] = rest_field(name="targetVault")
    """To use SQL authentication when connecting to targets, specify the vault where the login name
     and password secrets are stored."""
    connection_server_name: str = rest_field(name="connectionServerName")
    """The server name to use in the connection string when connecting to a target. Port number and
     instance name must be specified separately. Required."""
    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        target_type: str,
        target_authentication_type: Union[str, "_models.TargetAuthenticationType"],
        connection_server_name: str,
        target_vault: Optional["_models.VaultSecret"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SqlDbElasticPoolTargetProperties(TargetProperties, discriminator="SqlEp"):
    """The properties specific to elastic pool in Azure SQL Database.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar target_authentication_type: The type of authentication to use when connecting to a
     target. Required. Known values are: "Aad" and "Sql".
    :vartype target_authentication_type: str or
     ~azure.mgmt.databasewatcher.models.TargetAuthenticationType
    :ivar target_vault: To use SQL authentication when connecting to targets, specify the vault
     where the login name and password secrets are stored.
    :vartype target_vault: ~azure.mgmt.databasewatcher.models.VaultSecret
    :ivar connection_server_name: The server name to use in the connection string when connecting
     to a target. Port number and instance name must be specified separately. Required.
    :vartype connection_server_name: str
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.databasewatcher.models.ResourceProvisioningState
    :ivar target_type: The Azure SQL DB elastic pool target. Required. Default value is "SqlEp".
    :vartype target_type: str
    :ivar sql_ep_resource_id: The Azure resource ID of an Azure SQL DB elastic pool target.
     Required.
    :vartype sql_ep_resource_id: str
    :ivar anchor_database_resource_id: The Azure resource ID of the anchor database used to connect
     to an elastic pool. Required.
    :vartype anchor_database_resource_id: str
    :ivar read_intent: Set to true to monitor a high availability replica of specified target, if
     any.
    :vartype read_intent: bool
    """

    target_type: Literal["SqlEp"] = rest_discriminator(name="targetType")  # type: ignore
    """The Azure SQL DB elastic pool target. Required. Default value is \"SqlEp\"."""
    sql_ep_resource_id: str = rest_field(name="sqlEpResourceId")
    """The Azure resource ID of an Azure SQL DB elastic pool target. Required."""
    anchor_database_resource_id: str = rest_field(name="anchorDatabaseResourceId")
    """The Azure resource ID of the anchor database used to connect to an elastic pool. Required."""
    read_intent: Optional[bool] = rest_field(name="readIntent")
    """Set to true to monitor a high availability replica of specified target, if any."""

    @overload
    def __init__(
        self,
        *,
        target_authentication_type: Union[str, "_models.TargetAuthenticationType"],
        connection_server_name: str,
        sql_ep_resource_id: str,
        anchor_database_resource_id: str,
        target_vault: Optional["_models.VaultSecret"] = None,
        read_intent: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, target_type="SqlEp", **kwargs)


class SqlDbSingleDatabaseTargetProperties(TargetProperties, discriminator="SqlDb"):
    """The properties specific to single database in Azure SQL Database.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar target_authentication_type: The type of authentication to use when connecting to a
     target. Required. Known values are: "Aad" and "Sql".
    :vartype target_authentication_type: str or
     ~azure.mgmt.databasewatcher.models.TargetAuthenticationType
    :ivar target_vault: To use SQL authentication when connecting to targets, specify the vault
     where the login name and password secrets are stored.
    :vartype target_vault: ~azure.mgmt.databasewatcher.models.VaultSecret
    :ivar connection_server_name: The server name to use in the connection string when connecting
     to a target. Port number and instance name must be specified separately. Required.
    :vartype connection_server_name: str
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.databasewatcher.models.ResourceProvisioningState
    :ivar target_type: The Azure SQL DB single database target. Required. Default value is "SqlDb".
    :vartype target_type: str
    :ivar sql_db_resource_id: The Azure resource ID of an Azure SQL DB single database target.
     Required.
    :vartype sql_db_resource_id: str
    :ivar read_intent: Set to true to monitor a high availability replica of specified target, if
     any.
    :vartype read_intent: bool
    """

    target_type: Literal["SqlDb"] = rest_discriminator(name="targetType")  # type: ignore
    """The Azure SQL DB single database target. Required. Default value is \"SqlDb\"."""
    sql_db_resource_id: str = rest_field(name="sqlDbResourceId")
    """The Azure resource ID of an Azure SQL DB single database target. Required."""
    read_intent: Optional[bool] = rest_field(name="readIntent")
    """Set to true to monitor a high availability replica of specified target, if any."""

    @overload
    def __init__(
        self,
        *,
        target_authentication_type: Union[str, "_models.TargetAuthenticationType"],
        connection_server_name: str,
        sql_db_resource_id: str,
        target_vault: Optional["_models.VaultSecret"] = None,
        read_intent: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, target_type="SqlDb", **kwargs)


class SqlMiTargetProperties(TargetProperties, discriminator="SqlMi"):
    """The properties specific to Azure SQL Managed Instance targets.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar target_authentication_type: The type of authentication to use when connecting to a
     target. Required. Known values are: "Aad" and "Sql".
    :vartype target_authentication_type: str or
     ~azure.mgmt.databasewatcher.models.TargetAuthenticationType
    :ivar target_vault: To use SQL authentication when connecting to targets, specify the vault
     where the login name and password secrets are stored.
    :vartype target_vault: ~azure.mgmt.databasewatcher.models.VaultSecret
    :ivar connection_server_name: The server name to use in the connection string when connecting
     to a target. Port number and instance name must be specified separately. Required.
    :vartype connection_server_name: str
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.databasewatcher.models.ResourceProvisioningState
    :ivar target_type: The Azure SQL Managed Instance target. Required. Default value is "SqlMi".
    :vartype target_type: str
    :ivar sql_mi_resource_id: The Azure resource ID of an Azure SQL Managed Instance target.
     Required.
    :vartype sql_mi_resource_id: str
    :ivar connection_tcp_port: The TCP port number to optionally use in the connection string when
     connecting to an Azure SQL Managed Instance target.
    :vartype connection_tcp_port: int
    :ivar read_intent: Set to true to monitor a high availability replica of specified target, if
     any.
    :vartype read_intent: bool
    """

    target_type: Literal["SqlMi"] = rest_discriminator(name="targetType")  # type: ignore
    """The Azure SQL Managed Instance target. Required. Default value is \"SqlMi\"."""
    sql_mi_resource_id: str = rest_field(name="sqlMiResourceId")
    """The Azure resource ID of an Azure SQL Managed Instance target. Required."""
    connection_tcp_port: Optional[int] = rest_field(name="connectionTcpPort")
    """The TCP port number to optionally use in the connection string when connecting to an Azure SQL
     Managed Instance target."""
    read_intent: Optional[bool] = rest_field(name="readIntent")
    """Set to true to monitor a high availability replica of specified target, if any."""

    @overload
    def __init__(
        self,
        *,
        target_authentication_type: Union[str, "_models.TargetAuthenticationType"],
        connection_server_name: str,
        sql_mi_resource_id: str,
        target_vault: Optional["_models.VaultSecret"] = None,
        connection_tcp_port: Optional[int] = None,
        read_intent: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, target_type="SqlMi", **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.databasewatcher.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.databasewatcher.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy")
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="createdByType")
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(name="createdAt", format="rfc3339")
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy")
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="lastModifiedByType")
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(name="lastModifiedAt", format="rfc3339")
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Target(ProxyResource):
    """Concrete proxy resource types can be created by aliasing this type using a specific property
    type.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.databasewatcher.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.databasewatcher.models.TargetProperties
    """

    properties: Optional["_models.TargetProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.TargetProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.databasewatcher.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_model_base.Model):
    """User assigned identity properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""


class ValidationIssue(_model_base.Model):
    """The model of a health validation issue.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar error_code: The error code of the issue. Required.
    :vartype error_code: str
    :ivar error_message: The error message of the issue. Required.
    :vartype error_message: str
    :ivar additional_details: The additional details for the issue.
    :vartype additional_details: str
    :ivar recommendation_message: The recommendation for resolving the issue. Required.
    :vartype recommendation_message: str
    :ivar recommendation_url: The URL related to resolving the issue.
    :vartype recommendation_url: str
    :ivar related_resource_id: The resource ID of the Azure resource related to the issue.
    :vartype related_resource_id: str
    :ivar related_resource_type: The type of the Azure resource related to the issue.
    :vartype related_resource_type: str
    """

    error_code: str = rest_field(name="errorCode", visibility=["read"])
    """The error code of the issue. Required."""
    error_message: str = rest_field(name="errorMessage", visibility=["read"])
    """The error message of the issue. Required."""
    additional_details: Optional[str] = rest_field(name="additionalDetails", visibility=["read"])
    """The additional details for the issue."""
    recommendation_message: str = rest_field(name="recommendationMessage", visibility=["read"])
    """The recommendation for resolving the issue. Required."""
    recommendation_url: Optional[str] = rest_field(name="recommendationUrl", visibility=["read"])
    """The URL related to resolving the issue."""
    related_resource_id: Optional[str] = rest_field(name="relatedResourceId", visibility=["read"])
    """The resource ID of the Azure resource related to the issue."""
    related_resource_type: Optional[str] = rest_field(name="relatedResourceType", visibility=["read"])
    """The type of the Azure resource related to the issue."""


class VaultSecret(_model_base.Model):
    """The vault specific details required if using SQL authentication to connect to a target.

    :ivar akv_resource_id: The Azure resource ID of the Key Vault instance storing database
     authentication secrets.
    :vartype akv_resource_id: str
    :ivar akv_target_user: The path to the Key Vault secret storing the login name (aka user name,
     aka account name) for authentication to a target.
    :vartype akv_target_user: str
    :ivar akv_target_password: The path to the Key Vault secret storing the password for
     authentication to a target.
    :vartype akv_target_password: str
    """

    akv_resource_id: Optional[str] = rest_field(name="akvResourceId")
    """The Azure resource ID of the Key Vault instance storing database authentication secrets."""
    akv_target_user: Optional[str] = rest_field(name="akvTargetUser")
    """The path to the Key Vault secret storing the login name (aka user name, aka account name) for
     authentication to a target."""
    akv_target_password: Optional[str] = rest_field(name="akvTargetPassword")
    """The path to the Key Vault secret storing the password for authentication to a target."""

    @overload
    def __init__(
        self,
        *,
        akv_resource_id: Optional[str] = None,
        akv_target_user: Optional[str] = None,
        akv_target_password: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Watcher(TrackedResource):
    """The DatabaseWatcherProviderHub resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.databasewatcher.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.databasewatcher.models.WatcherProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.databasewatcher.models.ManagedServiceIdentityV4
    """

    properties: Optional["_models.WatcherProperties"] = rest_field()
    """The resource-specific properties for this resource."""
    identity: Optional["_models.ManagedServiceIdentityV4"] = rest_field()
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.WatcherProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentityV4"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WatcherProperties(_model_base.Model):
    """The RP specific properties of the resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar datastore: The data store for collected monitoring data.
    :vartype datastore: ~azure.mgmt.databasewatcher.models.Datastore
    :ivar status: The monitoring collection status of the watcher. Known values are: "Starting",
     "Running", "Stopping", "Stopped", and "Deleting".
    :vartype status: str or ~azure.mgmt.databasewatcher.models.WatcherStatus
    :ivar provisioning_state: The provisioning state of the resource watcher. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.databasewatcher.models.DatabaseWatcherProvisioningState
    :ivar default_alert_rule_identity_resource_id: The resource ID of a user-assigned managed
     identity that will be assigned to a new alert rule.
    :vartype default_alert_rule_identity_resource_id: str
    """

    datastore: Optional["_models.Datastore"] = rest_field()
    """The data store for collected monitoring data."""
    status: Optional[Union[str, "_models.WatcherStatus"]] = rest_field(visibility=["read"])
    """The monitoring collection status of the watcher. Known values are: \"Starting\", \"Running\",
     \"Stopping\", \"Stopped\", and \"Deleting\"."""
    provisioning_state: Optional[Union[str, "_models.DatabaseWatcherProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the resource watcher. Known values are: \"Succeeded\", \"Failed\",
     and \"Canceled\"."""
    default_alert_rule_identity_resource_id: Optional[str] = rest_field(name="defaultAlertRuleIdentityResourceId")
    """The resource ID of a user-assigned managed identity that will be assigned to a new alert rule."""

    @overload
    def __init__(
        self,
        *,
        datastore: Optional["_models.Datastore"] = None,
        default_alert_rule_identity_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WatcherUpdate(_model_base.Model):
    """The type used for update operations of the Watcher.

    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.databasewatcher.models.ManagedServiceIdentityV4
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.databasewatcher.models.WatcherUpdateProperties
    """

    identity: Optional["_models.ManagedServiceIdentityV4"] = rest_field()
    """The managed service identities assigned to this resource."""
    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    properties: Optional["_models.WatcherUpdateProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentityV4"] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.WatcherUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WatcherUpdateProperties(_model_base.Model):
    """The updatable properties of the Watcher.

    :ivar datastore: The data store for collected monitoring data.
    :vartype datastore: ~azure.mgmt.databasewatcher.models.Datastore
    :ivar default_alert_rule_identity_resource_id: The resource ID of a user-assigned managed
     identity that will be assigned to a new alert rule.
    :vartype default_alert_rule_identity_resource_id: str
    """

    datastore: Optional["_models.Datastore"] = rest_field()
    """The data store for collected monitoring data."""
    default_alert_rule_identity_resource_id: Optional[str] = rest_field(name="defaultAlertRuleIdentityResourceId")
    """The resource ID of a user-assigned managed identity that will be assigned to a new alert rule."""

    @overload
    def __init__(
        self,
        *,
        datastore: Optional["_models.Datastore"] = None,
        default_alert_rule_identity_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
