% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_api-value.R
\name{value}
\alias{value}
\alias{value.Future}
\alias{value.list}
\alias{value.listenv}
\alias{value.environment}
\title{The value of a future or the values of all elements in a container}
\usage{
value(...)

\method{value}{Future}(future, stdout = TRUE, signal = TRUE, drop = FALSE, ...)

\method{value}{list}(
  x,
  idxs = NULL,
  recursive = 0,
  reduce = NULL,
  stdout = TRUE,
  signal = TRUE,
  cancel = TRUE,
  interrupt = cancel,
  inorder = TRUE,
  drop = FALSE,
  force = TRUE,
  sleep = getOption("future.wait.interval", 0.01),
  ...
)

\method{value}{listenv}(
  x,
  idxs = NULL,
  recursive = 0,
  reduce = NULL,
  stdout = TRUE,
  signal = TRUE,
  cancel = TRUE,
  interrupt = cancel,
  inorder = TRUE,
  drop = FALSE,
  force = TRUE,
  sleep = getOption("future.wait.interval", 0.01),
  ...
)

\method{value}{environment}(x, ...)
}
\arguments{
\item{future, x}{A \link{Future}, an environment, a list, or a list environment.}

\item{stdout}{If TRUE, standard output captured while resolving futures
is relayed, otherwise not.}

\item{signal}{If TRUE, \link[base]{conditions} captured while resolving
futures are relayed, otherwise not.}

\item{drop}{If TRUE, resolved futures are minimized in size and invalidated
as soon the as their values have been collected and any output and
conditions have been relayed.
Combining \code{drop = TRUE} with \code{inorder = FALSE} reduces the memory use
sooner, especially avoiding the risk of holding on to future values until
the very end.}

\item{idxs}{(optional) integer or logical index specifying the subset of
elements to check.}

\item{recursive}{A non-negative number specifying how deep of a recursion
should be done.  If TRUE, an infinite recursion is used.  If FALSE or zero,
no recursion is performed.}

\item{reduce}{An optional function for reducing all the values.
Optional attribute \code{init} can be used to set initial value for the
reduction. If not specified, the first value will be used as the
initial value.
Reduction of values is done as soon as possible, but always in the
same order as \code{x}, unless \code{inorder} is FALSE.}

\item{cancel, interrupt}{If TRUE and \code{signal} is TRUE, non-resolved futures
are canceled as soon as an error is detected in one of the futures,
before signaling the error. Argument \code{interrupt} is passed to \code{cancel()}
controlling whether non-resolved futures should also be interrupted.}

\item{inorder}{If TRUE, then standard output and conditions are relayed,
and value reduction, is done in the order the futures occur in \code{x}, but
always as soon as possible. This is achieved by buffering the details
until they can be released. By setting \code{inorder = FALSE}, no buffering
takes place and everything is relayed and reduced as soon as a new future
is resolved. Regardlessly, the values are always returned in the same
order as \code{x}.}

\item{force}{(internal) If TRUE, captured standard output and captured
\link[base]{conditions} already relayed are relayed again, otherwise not.}

\item{sleep}{Number of seconds to wait before checking if futures have been
resolved since last time.}

\item{\ldots}{All arguments used by the S3 methods.}
}
\value{
\code{value()} of a Future object returns the value of the future, which can
be any type of \R object.

\code{value()} of a list, an environment, or a list environment returns an
object with the same number of elements and of the same class.
Names and dimension attributes are preserved, if available.
All future elements are replaced by their corresponding \code{value()} values.
For all other elements, the existing object is kept as-is.

If \code{signal} is TRUE and one of the futures produces an error, then
that error is relayed. Any remaining, non-resolved futures in \code{x} are
canceled, prior to signaling such an error.
If the future was interrupted, canceled, or the parallel worker terminated
abruptly ("crashed"), then a \link{FutureInterruptError} is signaled.
}
\description{
Gets the value of a future or the values of all elements (including futures)
in a container such as a list, an environment, or a list environment.
If one or more futures is unresolved, then this function blocks until all
queried futures are resolved.
}
\examples{
## ------------------------------------------------------
## A single future
## ------------------------------------------------------
x <- sample(100, size = 50)
f <- future(mean(x))
v <- value(f)
message("The average of 50 random numbers in [1,100] is: ", v)



## ------------------------------------------------------
## Ten futures
## ------------------------------------------------------
xs <- replicate(10, { list(sample(100, size = 50)) })
fs <- lapply(xs, function(x) { future(mean(x)) })

## The 10 values as a list (because 'fs' is a list)
vs <- value(fs)
message("The ten averages are:")
str(vs)

## The 10 values as a vector (by manually unlisting)
vs <- value(fs)
vs <- unlist(vs)
message("The ten averages are: ", paste(vs, collapse = ", "))

## The values as a vector (by reducing)
vs <- value(fs, reduce = c)
message("The ten averages are: ", paste(vs, collapse = ", "))

## Calculate the sum of the averages (by reducing)
total <- value(fs, reduce = `+`)
message("The sum of the ten averages is: ", total)
}
